# Authentication


## Log in




> Example request:

```bash
curl -X POST \
    "https://jobclass.bedigit.local/api/auth/login" \
    -H "Content-Type: application/json" \
    -H "Accept: application/json" \
    -H "Content-Language: en" \
    -H "X-AppApiToken: a25ydDlKdDRwT2wzYjAxV1hvc0hSUmQxYklTTE1pRHU=" \
    -H "X-AppType: docs" \
    -d '{"login":"user@demosite.com","password":"123456","captcha_key":"vel"}'

```

```javascript
const url = new URL(
    "https://jobclass.bedigit.local/api/auth/login"
);

let headers = {
    "Content-Type": "application/json",
    "Accept": "application/json",
    "Content-Language": "en",
    "X-AppApiToken": "a25ydDlKdDRwT2wzYjAxV1hvc0hSUmQxYklTTE1pRHU=",
    "X-AppType": "docs",
};

let body = {
    "login": "user@demosite.com",
    "password": "123456",
    "captcha_key": "vel"
}

fetch(url, {
    method: "POST",
    headers,
    body: JSON.stringify(body),
}).then(response => response.json());
```

```php

$client = new \GuzzleHttp\Client();
$response = $client->post(
    'https://jobclass.bedigit.local/api/auth/login',
    [
        'headers' => [
            'Accept' => 'application/json',
            'Content-Language' => 'en',
            'X-AppApiToken' => 'a25ydDlKdDRwT2wzYjAxV1hvc0hSUmQxYklTTE1pRHU=',
            'X-AppType' => 'docs',
        ],
        'json' => [
            'login' => 'user@demosite.com',
            'password' => '123456',
            'captcha_key' => 'vel',
        ],
    ]
);
$body = $response->getBody();
print_r(json_decode((string) $body));
```


> Example response (200):

```json
{
    "success": true,
    "message": null,
    "result": {
        "id": 4,
        "name": "User Demo",
        "username": null,
        "created_at_formatted": "Feb 27th, 2021 at 15:19",
        "photo_url": "https:\/\/www.gravatar.com\/avatar\/6c58d4583a9550a6e363976bc15caf67.jpg?s=80&d=http%3A%2F%2Fjobclass.bedigit.local%2Fimages%2Fuser.jpg&r=g"
    },
    "extra": {
        "authToken": "4|lLPkzdAZIPgHlN2P0GI0cLtrS4aBoz1BQQ8pNMAE",
        "tokenType": "Bearer",
        "isAdmin": false
    }
}
```
<div id="execution-results-POSTapi-auth-login" hidden>
    <blockquote>Received response<span id="execution-response-status-POSTapi-auth-login"></span>:</blockquote>
    <pre class="json"><code id="execution-response-content-POSTapi-auth-login"></code></pre>
</div>
<div id="execution-error-POSTapi-auth-login" hidden>
    <blockquote>Request failed with error:</blockquote>
    <pre><code id="execution-error-message-POSTapi-auth-login"></code></pre>
</div>
<form id="form-POSTapi-auth-login" data-method="POST" data-path="api/auth/login" data-authed="0" data-hasfiles="0" data-headers='{"Content-Type":"application\/json","Accept":"application\/json","Content-Language":"en","X-AppApiToken":"a25ydDlKdDRwT2wzYjAxV1hvc0hSUmQxYklTTE1pRHU=","X-AppType":"docs"}' onsubmit="event.preventDefault(); executeTryOut('POSTapi-auth-login', this);">
<h3>
    Request&nbsp;&nbsp;&nbsp;
        <button type="button" style="background-color: #8fbcd4; padding: 5px 10px; border-radius: 5px; border-width: thin;" id="btn-tryout-POSTapi-auth-login" onclick="tryItOut('POSTapi-auth-login');">Try it out ⚡</button>
    <button type="button" style="background-color: #c97a7e; padding: 5px 10px; border-radius: 5px; border-width: thin;" id="btn-canceltryout-POSTapi-auth-login" onclick="cancelTryOut('POSTapi-auth-login');" hidden>Cancel</button>&nbsp;&nbsp;
    <button type="submit" style="background-color: #6ac174; padding: 5px 10px; border-radius: 5px; border-width: thin;" id="btn-executetryout-POSTapi-auth-login" hidden>Send Request 💥</button>
    </h3>
<p>
<small class="badge badge-black">POST</small>
 <b><code>api/auth/login</code></b>
</p>
<h4 class="fancy-heading-panel"><b>Body Parameters</b></h4>
<p>
<b><code>login</code></b>&nbsp;&nbsp;<small>string</small>  &nbsp;
<input type="text" name="login" data-endpoint="POSTapi-auth-login" data-component="body" required  hidden>
<br>
The user's login (Can be email address or phone number).
</p>
<p>
<b><code>password</code></b>&nbsp;&nbsp;<small>string</small>  &nbsp;
<input type="password" name="password" data-endpoint="POSTapi-auth-login" data-component="body" required  hidden>
<br>
The user's password.
</p>
<p>
<b><code>captcha_key</code></b>&nbsp;&nbsp;<small>string</small>     <i>optional</i> &nbsp;
<input type="text" name="captcha_key" data-endpoint="POSTapi-auth-login" data-component="body"  hidden>
<br>
Key generated by the CAPTCHA endpoint calling (Required if the CAPTCHA verification is enabled from the Admin panel).
</p>

</form>


## Log out

<small class="badge badge-darkred">requires authentication</small>



> Example request:

```bash
curl -X GET \
    -G "https://jobclass.bedigit.local/api/auth/logout/8" \
    -H "Authorization: Bearer {YOUR_AUTH_TOKEN}" \
    -H "Content-Type: application/json" \
    -H "Accept: application/json" \
    -H "Content-Language: en" \
    -H "X-AppApiToken: a25ydDlKdDRwT2wzYjAxV1hvc0hSUmQxYklTTE1pRHU=" \
    -H "X-AppType: docs"
```

```javascript
const url = new URL(
    "https://jobclass.bedigit.local/api/auth/logout/8"
);

let headers = {
    "Authorization": "Bearer {YOUR_AUTH_TOKEN}",
    "Content-Type": "application/json",
    "Accept": "application/json",
    "Content-Language": "en",
    "X-AppApiToken": "a25ydDlKdDRwT2wzYjAxV1hvc0hSUmQxYklTTE1pRHU=",
    "X-AppType": "docs",
};


fetch(url, {
    method: "GET",
    headers,
}).then(response => response.json());
```

```php

$client = new \GuzzleHttp\Client();
$response = $client->get(
    'https://jobclass.bedigit.local/api/auth/logout/8',
    [
        'headers' => [
            'Authorization' => 'Bearer {YOUR_AUTH_TOKEN}',
            'Accept' => 'application/json',
            'Content-Language' => 'en',
            'X-AppApiToken' => 'a25ydDlKdDRwT2wzYjAxV1hvc0hSUmQxYklTTE1pRHU=',
            'X-AppType' => 'docs',
        ],
    ]
);
$body = $response->getBody();
print_r(json_decode((string) $body));
```


> Example response (200):

```json
{
    "success": true,
    "message": "You have been logged out. See you soon.",
    "result": null
}
```
<div id="execution-results-GETapi-auth-logout--userId-" hidden>
    <blockquote>Received response<span id="execution-response-status-GETapi-auth-logout--userId-"></span>:</blockquote>
    <pre class="json"><code id="execution-response-content-GETapi-auth-logout--userId-"></code></pre>
</div>
<div id="execution-error-GETapi-auth-logout--userId-" hidden>
    <blockquote>Request failed with error:</blockquote>
    <pre><code id="execution-error-message-GETapi-auth-logout--userId-"></code></pre>
</div>
<form id="form-GETapi-auth-logout--userId-" data-method="GET" data-path="api/auth/logout/{userId}" data-authed="1" data-hasfiles="0" data-headers='{"Authorization":"Bearer {YOUR_AUTH_TOKEN}","Content-Type":"application\/json","Accept":"application\/json","Content-Language":"en","X-AppApiToken":"a25ydDlKdDRwT2wzYjAxV1hvc0hSUmQxYklTTE1pRHU=","X-AppType":"docs"}' onsubmit="event.preventDefault(); executeTryOut('GETapi-auth-logout--userId-', this);">
<h3>
    Request&nbsp;&nbsp;&nbsp;
        <button type="button" style="background-color: #8fbcd4; padding: 5px 10px; border-radius: 5px; border-width: thin;" id="btn-tryout-GETapi-auth-logout--userId-" onclick="tryItOut('GETapi-auth-logout--userId-');">Try it out ⚡</button>
    <button type="button" style="background-color: #c97a7e; padding: 5px 10px; border-radius: 5px; border-width: thin;" id="btn-canceltryout-GETapi-auth-logout--userId-" onclick="cancelTryOut('GETapi-auth-logout--userId-');" hidden>Cancel</button>&nbsp;&nbsp;
    <button type="submit" style="background-color: #6ac174; padding: 5px 10px; border-radius: 5px; border-width: thin;" id="btn-executetryout-GETapi-auth-logout--userId-" hidden>Send Request 💥</button>
    </h3>
<p>
<small class="badge badge-green">GET</small>
 <b><code>api/auth/logout/{userId}</code></b>
</p>
<p>
<label id="auth-GETapi-auth-logout--userId-" hidden>Authorization header: <b><code>Bearer </code></b><input type="text" name="Authorization" data-prefix="Bearer " data-endpoint="GETapi-auth-logout--userId-" data-component="header"></label>
</p>
<h4 class="fancy-heading-panel"><b>URL Parameters</b></h4>
<p>
<b><code>userId</code></b>&nbsp;&nbsp;<small>integer</small>     <i>optional</i> &nbsp;
<input type="number" name="userId" data-endpoint="GETapi-auth-logout--userId-" data-component="url"  hidden>
<br>
The ID of the user to logout.
</p>
</form>


## Forgot password




> Example request:

```bash
curl -X POST \
    "https://jobclass.bedigit.local/api/auth/password/email" \
    -H "Content-Type: application/json" \
    -H "Accept: application/json" \
    -H "Content-Language: en" \
    -H "X-AppApiToken: a25ydDlKdDRwT2wzYjAxV1hvc0hSUmQxYklTTE1pRHU=" \
    -H "X-AppType: docs" \
    -d '{"login":"user@demosite.com","captcha_key":"accusamus"}'

```

```javascript
const url = new URL(
    "https://jobclass.bedigit.local/api/auth/password/email"
);

let headers = {
    "Content-Type": "application/json",
    "Accept": "application/json",
    "Content-Language": "en",
    "X-AppApiToken": "a25ydDlKdDRwT2wzYjAxV1hvc0hSUmQxYklTTE1pRHU=",
    "X-AppType": "docs",
};

let body = {
    "login": "user@demosite.com",
    "captcha_key": "accusamus"
}

fetch(url, {
    method: "POST",
    headers,
    body: JSON.stringify(body),
}).then(response => response.json());
```

```php

$client = new \GuzzleHttp\Client();
$response = $client->post(
    'https://jobclass.bedigit.local/api/auth/password/email',
    [
        'headers' => [
            'Accept' => 'application/json',
            'Content-Language' => 'en',
            'X-AppApiToken' => 'a25ydDlKdDRwT2wzYjAxV1hvc0hSUmQxYklTTE1pRHU=',
            'X-AppType' => 'docs',
        ],
        'json' => [
            'login' => 'user@demosite.com',
            'captcha_key' => 'accusamus',
        ],
    ]
);
$body = $response->getBody();
print_r(json_decode((string) $body));
```


> Example response (500):

```json
{
    "success": false,
    "message": "There was Issue with the Query",
    "result": null,
    "exception": {
        "message": "SQLSTATE[HY000]: General error: 1364 Field 'phone' doesn't have a default value (SQL: insert into `jc_password_resets` (`email`, `token`, `created_at`) values (user@demosite.com, $2y$10$Neq3v6Xel\/M6zUOzh9m\/3e2T35m2WY2ankJQQuLek5Q7S5oYTNLsC, 2021-06-22 10:10:19))",
        "file": "\/Users\/mayeul\/CODES\/PROJECTS\/jobclass\/vendor\/laravel\/framework\/src\/Illuminate\/Database\/Connection.php",
        "line": 692,
        "code": "HY000",
        "trace": [
            {
                "file": "\/Users\/mayeul\/CODES\/PROJECTS\/jobclass\/vendor\/laravel\/framework\/src\/Illuminate\/Database\/Connection.php",
                "line": 652,
                "function": "runQueryCallback",
                "class": "Illuminate\\Database\\Connection",
                "type": "->",
                "args": [
                    "insert into `jc_password_resets` (`email`, `token`, `created_at`) values (?, ?, ?)",
                    [
                        "user@demosite.com",
                        "$2y$10$Neq3v6Xel\/M6zUOzh9m\/3e2T35m2WY2ankJQQuLek5Q7S5oYTNLsC",
                        "2021-06-22T10:10:19.968369Z"
                    ],
                    {}
                ]
            },
            {
                "file": "\/Users\/mayeul\/CODES\/PROJECTS\/jobclass\/vendor\/laravel\/framework\/src\/Illuminate\/Database\/Connection.php",
                "line": 486,
                "function": "run",
                "class": "Illuminate\\Database\\Connection",
                "type": "->",
                "args": [
                    "insert into `jc_password_resets` (`email`, `token`, `created_at`) values (?, ?, ?)",
                    [
                        "user@demosite.com",
                        "$2y$10$Neq3v6Xel\/M6zUOzh9m\/3e2T35m2WY2ankJQQuLek5Q7S5oYTNLsC",
                        "2021-06-22T10:10:19.968369Z"
                    ],
                    {}
                ]
            },
            {
                "file": "\/Users\/mayeul\/CODES\/PROJECTS\/jobclass\/vendor\/laravel\/framework\/src\/Illuminate\/Database\/Connection.php",
                "line": 438,
                "function": "statement",
                "class": "Illuminate\\Database\\Connection",
                "type": "->",
                "args": [
                    "insert into `jc_password_resets` (`email`, `token`, `created_at`) values (?, ?, ?)",
                    [
                        "user@demosite.com",
                        "$2y$10$Neq3v6Xel\/M6zUOzh9m\/3e2T35m2WY2ankJQQuLek5Q7S5oYTNLsC",
                        "2021-06-22T10:10:19.968369Z"
                    ]
                ]
            },
            {
                "file": "\/Users\/mayeul\/CODES\/PROJECTS\/jobclass\/vendor\/laravel\/framework\/src\/Illuminate\/Database\/Query\/Builder.php",
                "line": 2959,
                "function": "insert",
                "class": "Illuminate\\Database\\Connection",
                "type": "->",
                "args": [
                    "insert into `jc_password_resets` (`email`, `token`, `created_at`) values (?, ?, ?)",
                    [
                        "user@demosite.com",
                        "$2y$10$Neq3v6Xel\/M6zUOzh9m\/3e2T35m2WY2ankJQQuLek5Q7S5oYTNLsC",
                        "2021-06-22T10:10:19.968369Z"
                    ]
                ]
            },
            {
                "file": "\/Users\/mayeul\/CODES\/PROJECTS\/jobclass\/vendor\/laravel\/framework\/src\/Illuminate\/Auth\/Passwords\/DatabaseTokenRepository.php",
                "line": 95,
                "function": "insert",
                "class": "Illuminate\\Database\\Query\\Builder",
                "type": "->",
                "args": [
                    [
                        {
                            "email": "user@demosite.com",
                            "token": "$2y$10$Neq3v6Xel\/M6zUOzh9m\/3e2T35m2WY2ankJQQuLek5Q7S5oYTNLsC",
                            "created_at": "2021-06-22T10:10:19.968369Z"
                        }
                    ]
                ]
            },
            {
                "file": "\/Users\/mayeul\/CODES\/PROJECTS\/jobclass\/vendor\/laravel\/framework\/src\/Illuminate\/Auth\/Passwords\/PasswordBroker.php",
                "line": 63,
                "function": "create",
                "class": "Illuminate\\Auth\\Passwords\\DatabaseTokenRepository",
                "type": "->",
                "args": [
                    {
                        "id": 4,
                        "country_code": "US",
                        "language_code": "en",
                        "user_type_id": "2",
                        "gender_id": "2",
                        "name": "User Demo",
                        "photo": null,
                        "about": "User Demo",
                        "phone": "+19877656243",
                        "phone_hidden": null,
                        "username": null,
                        "email": "user@demosite.com",
                        "email_verified_at": "2021-02-27T20:19:15.000000Z",
                        "is_admin": "0",
                        "can_be_impersonated": "1",
                        "disable_comments": "1",
                        "ip_addr": "228.104.74.107",
                        "provider": null,
                        "provider_id": null,
                        "email_token": null,
                        "phone_token": null,
                        "verified_email": "1",
                        "verified_phone": "1",
                        "accept_terms": "1",
                        "accept_marketing_offers": "0",
                        "time_zone": null,
                        "blocked": "0",
                        "closed": "0",
                        "last_activity": "2021-06-22T10:10:20.003848Z",
                        "last_login_at": "2021-05-09T20:24:47.000000Z",
                        "deleted_at": "2021-06-22T10:10:20.006201Z",
                        "created_at": "2021-02-27T20:19:15.000000Z",
                        "updated_at": "2021-05-10T00:39:35.000000Z",
                        "created_at_formatted": "Feb 27th, 2021 at 15:19",
                        "photo_url": "https:\/\/www.gravatar.com\/avatar\/6c58d4583a9550a6e363976bc15caf67.jpg?s=80&d=http%3A%2F%2Fjobclass.bedigit.local%2Fimages%2Fuser.jpg&r=g"
                    }
                ]
            },
            {
                "file": "\/Users\/mayeul\/CODES\/PROJECTS\/jobclass\/vendor\/laravel\/framework\/src\/Illuminate\/Auth\/Passwords\/PasswordBrokerManager.php",
                "line": 144,
                "function": "sendResetLink",
                "class": "Illuminate\\Auth\\Passwords\\PasswordBroker",
                "type": "->",
                "args": [
                    {
                        "email": "user@demosite.com"
                    }
                ]
            },
            {
                "file": "\/Users\/mayeul\/CODES\/PROJECTS\/jobclass\/vendor\/laravel\/framework\/src\/Illuminate\/Support\/Facades\/Facade.php",
                "line": 261,
                "function": "__call",
                "class": "Illuminate\\Auth\\Passwords\\PasswordBrokerManager",
                "type": "->",
                "args": [
                    "sendResetLink",
                    [
                        {
                            "email": "user@demosite.com"
                        }
                    ]
                ]
            },
            {
                "file": "\/Users\/mayeul\/CODES\/PROJECTS\/jobclass\/app\/Helpers\/Auth\/Traits\/SendsPasswordResetEmails.php",
                "line": 35,
                "function": "__callStatic",
                "class": "Illuminate\\Support\\Facades\\Facade",
                "type": "::",
                "args": [
                    "sendResetLink",
                    [
                        {
                            "email": "user@demosite.com"
                        }
                    ]
                ]
            },
            {
                "file": "\/Users\/mayeul\/CODES\/PROJECTS\/jobclass\/app\/Http\/Controllers\/Api\/Auth\/ForgotPasswordController.php",
                "line": 54,
                "function": "sendResetLinkEmail",
                "class": "App\\Http\\Controllers\\Api\\Auth\\ForgotPasswordController",
                "type": "->",
                "args": [
                    {
                        "attributes": {},
                        "request": {},
                        "query": {},
                        "server": {},
                        "files": {},
                        "cookies": {},
                        "headers": {}
                    }
                ]
            },
            {
                "file": "\/Users\/mayeul\/CODES\/PROJECTS\/jobclass\/vendor\/laravel\/framework\/src\/Illuminate\/Routing\/Controller.php",
                "line": 54,
                "function": "sendResetLink",
                "class": "App\\Http\\Controllers\\Api\\Auth\\ForgotPasswordController",
                "type": "->",
                "args": [
                    {
                        "attributes": {},
                        "request": {},
                        "query": {},
                        "server": {},
                        "files": {},
                        "cookies": {},
                        "headers": {}
                    }
                ]
            },
            {
                "file": "\/Users\/mayeul\/CODES\/PROJECTS\/jobclass\/vendor\/laravel\/framework\/src\/Illuminate\/Routing\/ControllerDispatcher.php",
                "line": 45,
                "function": "callAction",
                "class": "Illuminate\\Routing\\Controller",
                "type": "->",
                "args": [
                    "sendResetLink",
                    [
                        {
                            "attributes": {},
                            "request": {},
                            "query": {},
                            "server": {},
                            "files": {},
                            "cookies": {},
                            "headers": {}
                        }
                    ]
                ]
            },
            {
                "file": "\/Users\/mayeul\/CODES\/PROJECTS\/jobclass\/vendor\/laravel\/framework\/src\/Illuminate\/Routing\/Route.php",
                "line": 254,
                "function": "dispatch",
                "class": "Illuminate\\Routing\\ControllerDispatcher",
                "type": "->",
                "args": [
                    {
                        "uri": "api\/auth\/password\/email",
                        "methods": [
                            "POST"
                        ],
                        "action": {
                            "middleware": [
                                "api"
                            ],
                            "uses": "App\\Http\\Controllers\\Api\\Auth\\ForgotPasswordController@sendResetLink",
                            "controller": "App\\Http\\Controllers\\Api\\Auth\\ForgotPasswordController@sendResetLink",
                            "namespace": "App\\Http\\Controllers\\Api\\Auth",
                            "prefix": "api\/auth",
                            "where": [],
                            "as": "auth.password.email"
                        },
                        "isFallback": false,
                        "controller": {
                            "locale": null,
                            "countryCode": null,
                            "messages": [],
                            "errors": [],
                            "cacheExpiration": 86400,
                            "perPage": "16",
                            "disk": {},
                            "cookieExpiration": 86400
                        },
                        "defaults": [],
                        "wheres": {
                            "userId": "[0-9]+"
                        },
                        "parameters": [],
                        "parameterNames": [],
                        "computedMiddleware": [
                            "api"
                        ],
                        "compiled": {}
                    },
                    {
                        "locale": null,
                        "countryCode": null,
                        "messages": [],
                        "errors": [],
                        "cacheExpiration": 86400,
                        "perPage": "16",
                        "disk": {},
                        "cookieExpiration": 86400
                    },
                    "sendResetLink"
                ]
            },
            {
                "file": "\/Users\/mayeul\/CODES\/PROJECTS\/jobclass\/vendor\/laravel\/framework\/src\/Illuminate\/Routing\/Route.php",
                "line": 197,
                "function": "runController",
                "class": "Illuminate\\Routing\\Route",
                "type": "->",
                "args": []
            },
            {
                "file": "\/Users\/mayeul\/CODES\/PROJECTS\/jobclass\/vendor\/laravel\/framework\/src\/Illuminate\/Routing\/Router.php",
                "line": 695,
                "function": "run",
                "class": "Illuminate\\Routing\\Route",
                "type": "->",
                "args": []
            },
            {
                "file": "\/Users\/mayeul\/CODES\/PROJECTS\/jobclass\/vendor\/laravel\/framework\/src\/Illuminate\/Pipeline\/Pipeline.php",
                "line": 128,
                "function": "Illuminate\\Routing\\{closure}",
                "class": "Illuminate\\Routing\\Router",
                "type": "->",
                "args": [
                    {
                        "attributes": {},
                        "request": {},
                        "query": {},
                        "server": {},
                        "files": {},
                        "cookies": {},
                        "headers": {}
                    }
                ]
            },
            {
                "file": "\/Users\/mayeul\/CODES\/PROJECTS\/jobclass\/app\/Http\/Middleware\/IsVerifiedUser.php",
                "line": 137,
                "function": "Illuminate\\Pipeline\\{closure}",
                "class": "Illuminate\\Pipeline\\Pipeline",
                "type": "->",
                "args": [
                    {
                        "attributes": {},
                        "request": {},
                        "query": {},
                        "server": {},
                        "files": {},
                        "cookies": {},
                        "headers": {}
                    }
                ]
            },
            {
                "file": "\/Users\/mayeul\/CODES\/PROJECTS\/jobclass\/vendor\/laravel\/framework\/src\/Illuminate\/Pipeline\/Pipeline.php",
                "line": 167,
                "function": "handle",
                "class": "App\\Http\\Middleware\\IsVerifiedUser",
                "type": "->",
                "args": [
                    {
                        "attributes": {},
                        "request": {},
                        "query": {},
                        "server": {},
                        "files": {},
                        "cookies": {},
                        "headers": {}
                    },
                    {}
                ]
            },
            {
                "file": "\/Users\/mayeul\/CODES\/PROJECTS\/jobclass\/vendor\/laravel\/framework\/src\/Illuminate\/Routing\/Middleware\/SubstituteBindings.php",
                "line": 50,
                "function": "Illuminate\\Pipeline\\{closure}",
                "class": "Illuminate\\Pipeline\\Pipeline",
                "type": "->",
                "args": [
                    {
                        "attributes": {},
                        "request": {},
                        "query": {},
                        "server": {},
                        "files": {},
                        "cookies": {},
                        "headers": {}
                    }
                ]
            },
            {
                "file": "\/Users\/mayeul\/CODES\/PROJECTS\/jobclass\/vendor\/laravel\/framework\/src\/Illuminate\/Pipeline\/Pipeline.php",
                "line": 167,
                "function": "handle",
                "class": "Illuminate\\Routing\\Middleware\\SubstituteBindings",
                "type": "->",
                "args": [
                    {
                        "attributes": {},
                        "request": {},
                        "query": {},
                        "server": {},
                        "files": {},
                        "cookies": {},
                        "headers": {}
                    },
                    {}
                ]
            },
            {
                "file": "\/Users\/mayeul\/CODES\/PROJECTS\/jobclass\/vendor\/laravel\/framework\/src\/Illuminate\/Routing\/Middleware\/ThrottleRequests.php",
                "line": 127,
                "function": "Illuminate\\Pipeline\\{closure}",
                "class": "Illuminate\\Pipeline\\Pipeline",
                "type": "->",
                "args": [
                    {
                        "attributes": {},
                        "request": {},
                        "query": {},
                        "server": {},
                        "files": {},
                        "cookies": {},
                        "headers": {}
                    }
                ]
            },
            {
                "file": "\/Users\/mayeul\/CODES\/PROJECTS\/jobclass\/vendor\/laravel\/framework\/src\/Illuminate\/Routing\/Middleware\/ThrottleRequests.php",
                "line": 103,
                "function": "handleRequest",
                "class": "Illuminate\\Routing\\Middleware\\ThrottleRequests",
                "type": "->",
                "args": [
                    {
                        "attributes": {},
                        "request": {},
                        "query": {},
                        "server": {},
                        "files": {},
                        "cookies": {},
                        "headers": {}
                    },
                    {},
                    [
                        {
                            "key": "8a5da52ed126447d359e70c05721a8aa",
                            "maxAttempts": 60,
                            "decayMinutes": 1,
                            "responseCallback": null
                        }
                    ]
                ]
            },
            {
                "file": "\/Users\/mayeul\/CODES\/PROJECTS\/jobclass\/vendor\/laravel\/framework\/src\/Illuminate\/Routing\/Middleware\/ThrottleRequests.php",
                "line": 55,
                "function": "handleRequestUsingNamedLimiter",
                "class": "Illuminate\\Routing\\Middleware\\ThrottleRequests",
                "type": "->",
                "args": [
                    {
                        "attributes": {},
                        "request": {},
                        "query": {},
                        "server": {},
                        "files": {},
                        "cookies": {},
                        "headers": {}
                    },
                    {},
                    "api",
                    {}
                ]
            },
            {
                "file": "\/Users\/mayeul\/CODES\/PROJECTS\/jobclass\/vendor\/laravel\/framework\/src\/Illuminate\/Pipeline\/Pipeline.php",
                "line": 167,
                "function": "handle",
                "class": "Illuminate\\Routing\\Middleware\\ThrottleRequests",
                "type": "->",
                "args": [
                    {
                        "attributes": {},
                        "request": {},
                        "query": {},
                        "server": {},
                        "files": {},
                        "cookies": {},
                        "headers": {}
                    },
                    {},
                    "api"
                ]
            },
            {
                "file": "\/Users\/mayeul\/CODES\/PROJECTS\/jobclass\/vendor\/laravel\/sanctum\/src\/Http\/Middleware\/EnsureFrontendRequestsAreStateful.php",
                "line": 33,
                "function": "Illuminate\\Pipeline\\{closure}",
                "class": "Illuminate\\Pipeline\\Pipeline",
                "type": "->",
                "args": [
                    {
                        "attributes": {},
                        "request": {},
                        "query": {},
                        "server": {},
                        "files": {},
                        "cookies": {},
                        "headers": {}
                    }
                ]
            },
            {
                "file": "\/Users\/mayeul\/CODES\/PROJECTS\/jobclass\/vendor\/laravel\/framework\/src\/Illuminate\/Pipeline\/Pipeline.php",
                "line": 128,
                "function": "Laravel\\Sanctum\\Http\\Middleware\\{closure}",
                "class": "Laravel\\Sanctum\\Http\\Middleware\\EnsureFrontendRequestsAreStateful",
                "type": "->",
                "args": [
                    {
                        "attributes": {},
                        "request": {},
                        "query": {},
                        "server": {},
                        "files": {},
                        "cookies": {},
                        "headers": {}
                    }
                ]
            },
            {
                "file": "\/Users\/mayeul\/CODES\/PROJECTS\/jobclass\/vendor\/laravel\/framework\/src\/Illuminate\/Pipeline\/Pipeline.php",
                "line": 103,
                "function": "Illuminate\\Pipeline\\{closure}",
                "class": "Illuminate\\Pipeline\\Pipeline",
                "type": "->",
                "args": [
                    {
                        "attributes": {},
                        "request": {},
                        "query": {},
                        "server": {},
                        "files": {},
                        "cookies": {},
                        "headers": {}
                    }
                ]
            },
            {
                "file": "\/Users\/mayeul\/CODES\/PROJECTS\/jobclass\/vendor\/laravel\/sanctum\/src\/Http\/Middleware\/EnsureFrontendRequestsAreStateful.php",
                "line": 34,
                "function": "then",
                "class": "Illuminate\\Pipeline\\Pipeline",
                "type": "->",
                "args": [
                    {}
                ]
            },
            {
                "file": "\/Users\/mayeul\/CODES\/PROJECTS\/jobclass\/vendor\/laravel\/framework\/src\/Illuminate\/Pipeline\/Pipeline.php",
                "line": 167,
                "function": "handle",
                "class": "Laravel\\Sanctum\\Http\\Middleware\\EnsureFrontendRequestsAreStateful",
                "type": "->",
                "args": [
                    {
                        "attributes": {},
                        "request": {},
                        "query": {},
                        "server": {},
                        "files": {},
                        "cookies": {},
                        "headers": {}
                    },
                    {}
                ]
            },
            {
                "file": "\/Users\/mayeul\/CODES\/PROJECTS\/jobclass\/app\/Http\/Middleware\/VerifyAPIAccess.php",
                "line": 47,
                "function": "Illuminate\\Pipeline\\{closure}",
                "class": "Illuminate\\Pipeline\\Pipeline",
                "type": "->",
                "args": [
                    {
                        "attributes": {},
                        "request": {},
                        "query": {},
                        "server": {},
                        "files": {},
                        "cookies": {},
                        "headers": {}
                    }
                ]
            },
            {
                "file": "\/Users\/mayeul\/CODES\/PROJECTS\/jobclass\/vendor\/laravel\/framework\/src\/Illuminate\/Pipeline\/Pipeline.php",
                "line": 167,
                "function": "handle",
                "class": "App\\Http\\Middleware\\VerifyAPIAccess",
                "type": "->",
                "args": [
                    {
                        "attributes": {},
                        "request": {},
                        "query": {},
                        "server": {},
                        "files": {},
                        "cookies": {},
                        "headers": {}
                    },
                    {}
                ]
            },
            {
                "file": "\/Users\/mayeul\/CODES\/PROJECTS\/jobclass\/vendor\/laravel\/framework\/src\/Illuminate\/Pipeline\/Pipeline.php",
                "line": 103,
                "function": "Illuminate\\Pipeline\\{closure}",
                "class": "Illuminate\\Pipeline\\Pipeline",
                "type": "->",
                "args": [
                    {
                        "attributes": {},
                        "request": {},
                        "query": {},
                        "server": {},
                        "files": {},
                        "cookies": {},
                        "headers": {}
                    }
                ]
            },
            {
                "file": "\/Users\/mayeul\/CODES\/PROJECTS\/jobclass\/vendor\/laravel\/framework\/src\/Illuminate\/Routing\/Router.php",
                "line": 697,
                "function": "then",
                "class": "Illuminate\\Pipeline\\Pipeline",
                "type": "->",
                "args": [
                    {}
                ]
            },
            {
                "file": "\/Users\/mayeul\/CODES\/PROJECTS\/jobclass\/vendor\/laravel\/framework\/src\/Illuminate\/Routing\/Router.php",
                "line": 672,
                "function": "runRouteWithinStack",
                "class": "Illuminate\\Routing\\Router",
                "type": "->",
                "args": [
                    {
                        "uri": "api\/auth\/password\/email",
                        "methods": [
                            "POST"
                        ],
                        "action": {
                            "middleware": [
                                "api"
                            ],
                            "uses": "App\\Http\\Controllers\\Api\\Auth\\ForgotPasswordController@sendResetLink",
                            "controller": "App\\Http\\Controllers\\Api\\Auth\\ForgotPasswordController@sendResetLink",
                            "namespace": "App\\Http\\Controllers\\Api\\Auth",
                            "prefix": "api\/auth",
                            "where": [],
                            "as": "auth.password.email"
                        },
                        "isFallback": false,
                        "controller": {
                            "locale": null,
                            "countryCode": null,
                            "messages": [],
                            "errors": [],
                            "cacheExpiration": 86400,
                            "perPage": "16",
                            "disk": {},
                            "cookieExpiration": 86400
                        },
                        "defaults": [],
                        "wheres": {
                            "userId": "[0-9]+"
                        },
                        "parameters": [],
                        "parameterNames": [],
                        "computedMiddleware": [
                            "api"
                        ],
                        "compiled": {}
                    },
                    {
                        "attributes": {},
                        "request": {},
                        "query": {},
                        "server": {},
                        "files": {},
                        "cookies": {},
                        "headers": {}
                    }
                ]
            },
            {
                "file": "\/Users\/mayeul\/CODES\/PROJECTS\/jobclass\/vendor\/laravel\/framework\/src\/Illuminate\/Routing\/Router.php",
                "line": 636,
                "function": "runRoute",
                "class": "Illuminate\\Routing\\Router",
                "type": "->",
                "args": [
                    {
                        "attributes": {},
                        "request": {},
                        "query": {},
                        "server": {},
                        "files": {},
                        "cookies": {},
                        "headers": {}
                    },
                    {
                        "uri": "api\/auth\/password\/email",
                        "methods": [
                            "POST"
                        ],
                        "action": {
                            "middleware": [
                                "api"
                            ],
                            "uses": "App\\Http\\Controllers\\Api\\Auth\\ForgotPasswordController@sendResetLink",
                            "controller": "App\\Http\\Controllers\\Api\\Auth\\ForgotPasswordController@sendResetLink",
                            "namespace": "App\\Http\\Controllers\\Api\\Auth",
                            "prefix": "api\/auth",
                            "where": [],
                            "as": "auth.password.email"
                        },
                        "isFallback": false,
                        "controller": {
                            "locale": null,
                            "countryCode": null,
                            "messages": [],
                            "errors": [],
                            "cacheExpiration": 86400,
                            "perPage": "16",
                            "disk": {},
                            "cookieExpiration": 86400
                        },
                        "defaults": [],
                        "wheres": {
                            "userId": "[0-9]+"
                        },
                        "parameters": [],
                        "parameterNames": [],
                        "computedMiddleware": [
                            "api"
                        ],
                        "compiled": {}
                    }
                ]
            },
            {
                "file": "\/Users\/mayeul\/CODES\/PROJECTS\/jobclass\/vendor\/laravel\/framework\/src\/Illuminate\/Routing\/Router.php",
                "line": 625,
                "function": "dispatchToRoute",
                "class": "Illuminate\\Routing\\Router",
                "type": "->",
                "args": [
                    {
                        "attributes": {},
                        "request": {},
                        "query": {},
                        "server": {},
                        "files": {},
                        "cookies": {},
                        "headers": {}
                    }
                ]
            },
            {
                "file": "\/Users\/mayeul\/CODES\/PROJECTS\/jobclass\/vendor\/laravel\/framework\/src\/Illuminate\/Foundation\/Http\/Kernel.php",
                "line": 166,
                "function": "dispatch",
                "class": "Illuminate\\Routing\\Router",
                "type": "->",
                "args": [
                    {
                        "attributes": {},
                        "request": {},
                        "query": {},
                        "server": {},
                        "files": {},
                        "cookies": {},
                        "headers": {}
                    }
                ]
            },
            {
                "file": "\/Users\/mayeul\/CODES\/PROJECTS\/jobclass\/vendor\/laravel\/framework\/src\/Illuminate\/Pipeline\/Pipeline.php",
                "line": 128,
                "function": "Illuminate\\Foundation\\Http\\{closure}",
                "class": "Illuminate\\Foundation\\Http\\Kernel",
                "type": "->",
                "args": [
                    {
                        "attributes": {},
                        "request": {},
                        "query": {},
                        "server": {},
                        "files": {},
                        "cookies": {},
                        "headers": {}
                    }
                ]
            },
            {
                "file": "\/Users\/mayeul\/CODES\/PROJECTS\/jobclass\/vendor\/laravel\/framework\/src\/Illuminate\/Foundation\/Http\/Middleware\/TransformsRequest.php",
                "line": 21,
                "function": "Illuminate\\Pipeline\\{closure}",
                "class": "Illuminate\\Pipeline\\Pipeline",
                "type": "->",
                "args": [
                    {
                        "attributes": {},
                        "request": {},
                        "query": {},
                        "server": {},
                        "files": {},
                        "cookies": {},
                        "headers": {}
                    }
                ]
            },
            {
                "file": "\/Users\/mayeul\/CODES\/PROJECTS\/jobclass\/vendor\/laravel\/framework\/src\/Illuminate\/Foundation\/Http\/Middleware\/ConvertEmptyStringsToNull.php",
                "line": 31,
                "function": "handle",
                "class": "Illuminate\\Foundation\\Http\\Middleware\\TransformsRequest",
                "type": "->",
                "args": [
                    {
                        "attributes": {},
                        "request": {},
                        "query": {},
                        "server": {},
                        "files": {},
                        "cookies": {},
                        "headers": {}
                    },
                    {}
                ]
            },
            {
                "file": "\/Users\/mayeul\/CODES\/PROJECTS\/jobclass\/vendor\/laravel\/framework\/src\/Illuminate\/Pipeline\/Pipeline.php",
                "line": 167,
                "function": "handle",
                "class": "Illuminate\\Foundation\\Http\\Middleware\\ConvertEmptyStringsToNull",
                "type": "->",
                "args": [
                    {
                        "attributes": {},
                        "request": {},
                        "query": {},
                        "server": {},
                        "files": {},
                        "cookies": {},
                        "headers": {}
                    },
                    {}
                ]
            },
            {
                "file": "\/Users\/mayeul\/CODES\/PROJECTS\/jobclass\/vendor\/laravel\/framework\/src\/Illuminate\/Foundation\/Http\/Middleware\/TransformsRequest.php",
                "line": 21,
                "function": "Illuminate\\Pipeline\\{closure}",
                "class": "Illuminate\\Pipeline\\Pipeline",
                "type": "->",
                "args": [
                    {
                        "attributes": {},
                        "request": {},
                        "query": {},
                        "server": {},
                        "files": {},
                        "cookies": {},
                        "headers": {}
                    }
                ]
            },
            {
                "file": "\/Users\/mayeul\/CODES\/PROJECTS\/jobclass\/vendor\/laravel\/framework\/src\/Illuminate\/Foundation\/Http\/Middleware\/TrimStrings.php",
                "line": 40,
                "function": "handle",
                "class": "Illuminate\\Foundation\\Http\\Middleware\\TransformsRequest",
                "type": "->",
                "args": [
                    {
                        "attributes": {},
                        "request": {},
                        "query": {},
                        "server": {},
                        "files": {},
                        "cookies": {},
                        "headers": {}
                    },
                    {}
                ]
            },
            {
                "file": "\/Users\/mayeul\/CODES\/PROJECTS\/jobclass\/vendor\/laravel\/framework\/src\/Illuminate\/Pipeline\/Pipeline.php",
                "line": 167,
                "function": "handle",
                "class": "Illuminate\\Foundation\\Http\\Middleware\\TrimStrings",
                "type": "->",
                "args": [
                    {
                        "attributes": {},
                        "request": {},
                        "query": {},
                        "server": {},
                        "files": {},
                        "cookies": {},
                        "headers": {}
                    },
                    {}
                ]
            },
            {
                "file": "\/Users\/mayeul\/CODES\/PROJECTS\/jobclass\/vendor\/laravel\/framework\/src\/Illuminate\/Foundation\/Http\/Middleware\/ValidatePostSize.php",
                "line": 27,
                "function": "Illuminate\\Pipeline\\{closure}",
                "class": "Illuminate\\Pipeline\\Pipeline",
                "type": "->",
                "args": [
                    {
                        "attributes": {},
                        "request": {},
                        "query": {},
                        "server": {},
                        "files": {},
                        "cookies": {},
                        "headers": {}
                    }
                ]
            },
            {
                "file": "\/Users\/mayeul\/CODES\/PROJECTS\/jobclass\/vendor\/laravel\/framework\/src\/Illuminate\/Pipeline\/Pipeline.php",
                "line": 167,
                "function": "handle",
                "class": "Illuminate\\Foundation\\Http\\Middleware\\ValidatePostSize",
                "type": "->",
                "args": [
                    {
                        "attributes": {},
                        "request": {},
                        "query": {},
                        "server": {},
                        "files": {},
                        "cookies": {},
                        "headers": {}
                    },
                    {}
                ]
            },
            {
                "file": "\/Users\/mayeul\/CODES\/PROJECTS\/jobclass\/app\/Http\/Middleware\/PreventRequestsDuringMaintenance.php",
                "line": 75,
                "function": "Illuminate\\Pipeline\\{closure}",
                "class": "Illuminate\\Pipeline\\Pipeline",
                "type": "->",
                "args": [
                    {
                        "attributes": {},
                        "request": {},
                        "query": {},
                        "server": {},
                        "files": {},
                        "cookies": {},
                        "headers": {}
                    }
                ]
            },
            {
                "file": "\/Users\/mayeul\/CODES\/PROJECTS\/jobclass\/vendor\/laravel\/framework\/src\/Illuminate\/Pipeline\/Pipeline.php",
                "line": 167,
                "function": "handle",
                "class": "App\\Http\\Middleware\\PreventRequestsDuringMaintenance",
                "type": "->",
                "args": [
                    {
                        "attributes": {},
                        "request": {},
                        "query": {},
                        "server": {},
                        "files": {},
                        "cookies": {},
                        "headers": {}
                    },
                    {}
                ]
            },
            {
                "file": "\/Users\/mayeul\/CODES\/PROJECTS\/jobclass\/vendor\/fruitcake\/laravel-cors\/src\/HandleCors.php",
                "line": 52,
                "function": "Illuminate\\Pipeline\\{closure}",
                "class": "Illuminate\\Pipeline\\Pipeline",
                "type": "->",
                "args": [
                    {
                        "attributes": {},
                        "request": {},
                        "query": {},
                        "server": {},
                        "files": {},
                        "cookies": {},
                        "headers": {}
                    }
                ]
            },
            {
                "file": "\/Users\/mayeul\/CODES\/PROJECTS\/jobclass\/vendor\/laravel\/framework\/src\/Illuminate\/Pipeline\/Pipeline.php",
                "line": 167,
                "function": "handle",
                "class": "Fruitcake\\Cors\\HandleCors",
                "type": "->",
                "args": [
                    {
                        "attributes": {},
                        "request": {},
                        "query": {},
                        "server": {},
                        "files": {},
                        "cookies": {},
                        "headers": {}
                    },
                    {}
                ]
            },
            {
                "file": "\/Users\/mayeul\/CODES\/PROJECTS\/jobclass\/vendor\/fideloper\/proxy\/src\/TrustProxies.php",
                "line": 57,
                "function": "Illuminate\\Pipeline\\{closure}",
                "class": "Illuminate\\Pipeline\\Pipeline",
                "type": "->",
                "args": [
                    {
                        "attributes": {},
                        "request": {},
                        "query": {},
                        "server": {},
                        "files": {},
                        "cookies": {},
                        "headers": {}
                    }
                ]
            },
            {
                "file": "\/Users\/mayeul\/CODES\/PROJECTS\/jobclass\/vendor\/laravel\/framework\/src\/Illuminate\/Pipeline\/Pipeline.php",
                "line": 167,
                "function": "handle",
                "class": "Fideloper\\Proxy\\TrustProxies",
                "type": "->",
                "args": [
                    {
                        "attributes": {},
                        "request": {},
                        "query": {},
                        "server": {},
                        "files": {},
                        "cookies": {},
                        "headers": {}
                    },
                    {}
                ]
            },
            {
                "file": "\/Users\/mayeul\/CODES\/PROJECTS\/jobclass\/vendor\/laravel\/framework\/src\/Illuminate\/Pipeline\/Pipeline.php",
                "line": 103,
                "function": "Illuminate\\Pipeline\\{closure}",
                "class": "Illuminate\\Pipeline\\Pipeline",
                "type": "->",
                "args": [
                    {
                        "attributes": {},
                        "request": {},
                        "query": {},
                        "server": {},
                        "files": {},
                        "cookies": {},
                        "headers": {}
                    }
                ]
            },
            {
                "file": "\/Users\/mayeul\/CODES\/PROJECTS\/jobclass\/vendor\/laravel\/framework\/src\/Illuminate\/Foundation\/Http\/Kernel.php",
                "line": 141,
                "function": "then",
                "class": "Illuminate\\Pipeline\\Pipeline",
                "type": "->",
                "args": [
                    {}
                ]
            },
            {
                "file": "\/Users\/mayeul\/CODES\/PROJECTS\/jobclass\/vendor\/laravel\/framework\/src\/Illuminate\/Foundation\/Http\/Kernel.php",
                "line": 110,
                "function": "sendRequestThroughRouter",
                "class": "Illuminate\\Foundation\\Http\\Kernel",
                "type": "->",
                "args": [
                    {
                        "attributes": {},
                        "request": {},
                        "query": {},
                        "server": {},
                        "files": {},
                        "cookies": {},
                        "headers": {}
                    }
                ]
            },
            {
                "file": "\/Users\/mayeul\/CODES\/PROJECTS\/jobclass\/vendor\/knuckleswtf\/scribe\/src\/Extracting\/Strategies\/Responses\/ResponseCalls.php",
                "line": 324,
                "function": "handle",
                "class": "Illuminate\\Foundation\\Http\\Kernel",
                "type": "->",
                "args": [
                    {
                        "attributes": {},
                        "request": {},
                        "query": {},
                        "server": {},
                        "files": {},
                        "cookies": {},
                        "headers": {}
                    }
                ]
            },
            {
                "file": "\/Users\/mayeul\/CODES\/PROJECTS\/jobclass\/vendor\/knuckleswtf\/scribe\/src\/Extracting\/Strategies\/Responses\/ResponseCalls.php",
                "line": 305,
                "function": "callLaravelOrLumenRoute",
                "class": "Knuckles\\Scribe\\Extracting\\Strategies\\Responses\\ResponseCalls",
                "type": "->",
                "args": [
                    {
                        "attributes": {},
                        "request": {},
                        "query": {},
                        "server": {},
                        "files": {},
                        "cookies": {},
                        "headers": {}
                    }
                ]
            },
            {
                "file": "\/Users\/mayeul\/CODES\/PROJECTS\/jobclass\/vendor\/knuckleswtf\/scribe\/src\/Extracting\/Strategies\/Responses\/ResponseCalls.php",
                "line": 76,
                "function": "makeApiCall",
                "class": "Knuckles\\Scribe\\Extracting\\Strategies\\Responses\\ResponseCalls",
                "type": "->",
                "args": [
                    {
                        "attributes": {},
                        "request": {},
                        "query": {},
                        "server": {},
                        "files": {},
                        "cookies": {},
                        "headers": {}
                    },
                    {
                        "uri": "api\/auth\/password\/email",
                        "methods": [
                            "POST"
                        ],
                        "action": {
                            "middleware": [
                                "api"
                            ],
                            "uses": "App\\Http\\Controllers\\Api\\Auth\\ForgotPasswordController@sendResetLink",
                            "controller": "App\\Http\\Controllers\\Api\\Auth\\ForgotPasswordController@sendResetLink",
                            "namespace": "App\\Http\\Controllers\\Api\\Auth",
                            "prefix": "api\/auth",
                            "where": [],
                            "as": "auth.password.email"
                        },
                        "isFallback": false,
                        "controller": {
                            "locale": null,
                            "countryCode": null,
                            "messages": [],
                            "errors": [],
                            "cacheExpiration": 86400,
                            "perPage": "16",
                            "disk": {},
                            "cookieExpiration": 86400
                        },
                        "defaults": [],
                        "wheres": {
                            "userId": "[0-9]+"
                        },
                        "parameters": [],
                        "parameterNames": [],
                        "computedMiddleware": [
                            "api"
                        ],
                        "compiled": {}
                    }
                ]
            },
            {
                "file": "\/Users\/mayeul\/CODES\/PROJECTS\/jobclass\/vendor\/knuckleswtf\/scribe\/src\/Extracting\/Strategies\/Responses\/ResponseCalls.php",
                "line": 51,
                "function": "makeResponseCall",
                "class": "Knuckles\\Scribe\\Extracting\\Strategies\\Responses\\ResponseCalls",
                "type": "->",
                "args": [
                    {
                        "uri": "api\/auth\/password\/email",
                        "methods": [
                            "POST"
                        ],
                        "action": {
                            "middleware": [
                                "api"
                            ],
                            "uses": "App\\Http\\Controllers\\Api\\Auth\\ForgotPasswordController@sendResetLink",
                            "controller": "App\\Http\\Controllers\\Api\\Auth\\ForgotPasswordController@sendResetLink",
                            "namespace": "App\\Http\\Controllers\\Api\\Auth",
                            "prefix": "api\/auth",
                            "where": [],
                            "as": "auth.password.email"
                        },
                        "isFallback": false,
                        "controller": {
                            "locale": null,
                            "countryCode": null,
                            "messages": [],
                            "errors": [],
                            "cacheExpiration": 86400,
                            "perPage": "16",
                            "disk": {},
                            "cookieExpiration": 86400
                        },
                        "defaults": [],
                        "wheres": {
                            "userId": "[0-9]+"
                        },
                        "parameters": [],
                        "parameterNames": [],
                        "computedMiddleware": [
                            "api"
                        ],
                        "compiled": {}
                    },
                    {
                        "id": "0ede357cfa17e8746504eb85c997884f",
                        "methods": [
                            "POST"
                        ],
                        "uri": "api\/auth\/password\/email",
                        "metadata": {
                            "groupName": "Authentication",
                            "groupDescription": "",
                            "title": "Forgot password",
                            "description": "",
                            "authenticated": false
                        },
                        "urlParameters": [],
                        "cleanUrlParameters": [],
                        "boundUri": "api\/auth\/password\/email",
                        "auth": null,
                        "queryParameters": [],
                        "cleanQueryParameters": [],
                        "headers": {
                            "Content-Type": "application\/json",
                            "Accept": "application\/json",
                            "Content-Language": "en",
                            "X-AppApiToken": "a25ydDlKdDRwT2wzYjAxV1hvc0hSUmQxYklTTE1pRHU=",
                            "X-AppType": "docs"
                        },
                        "bodyParameters": {
                            "login": {
                                "name": "login",
                                "type": "string",
                                "description": "The user's login (Can be email address or phone number).",
                                "required": true,
                                "value": "user@demosite.com"
                            },
                            "captcha_key": {
                                "name": "captcha_key",
                                "type": "string",
                                "description": "Key generated by the CAPTCHA endpoint calling (Required if the CAPTCHA verification is enabled from the Admin panel).",
                                "required": false,
                                "value": "accusamus"
                            }
                        },
                        "cleanBodyParameters": {
                            "login": "user@demosite.com",
                            "captcha_key": "accusamus"
                        },
                        "fileParameters": [],
                        "responses": []
                    },
                    {
                        "methods": [
                            "*"
                        ],
                        "config": {
                            "app.env": "local",
                            "app.debug": false
                        },
                        "queryParams": [],
                        "bodyParams": [],
                        "fileParams": [],
                        "cookies": []
                    }
                ]
            },
            {
                "file": "\/Users\/mayeul\/CODES\/PROJECTS\/jobclass\/vendor\/knuckleswtf\/scribe\/src\/Extracting\/Strategies\/Responses\/ResponseCalls.php",
                "line": 41,
                "function": "makeResponseCallIfEnabledAndNoSuccessResponses",
                "class": "Knuckles\\Scribe\\Extracting\\Strategies\\Responses\\ResponseCalls",
                "type": "->",
                "args": [
                    {
                        "uri": "api\/auth\/password\/email",
                        "methods": [
                            "POST"
                        ],
                        "action": {
                            "middleware": [
                                "api"
                            ],
                            "uses": "App\\Http\\Controllers\\Api\\Auth\\ForgotPasswordController@sendResetLink",
                            "controller": "App\\Http\\Controllers\\Api\\Auth\\ForgotPasswordController@sendResetLink",
                            "namespace": "App\\Http\\Controllers\\Api\\Auth",
                            "prefix": "api\/auth",
                            "where": [],
                            "as": "auth.password.email"
                        },
                        "isFallback": false,
                        "controller": {
                            "locale": null,
                            "countryCode": null,
                            "messages": [],
                            "errors": [],
                            "cacheExpiration": 86400,
                            "perPage": "16",
                            "disk": {},
                            "cookieExpiration": 86400
                        },
                        "defaults": [],
                        "wheres": {
                            "userId": "[0-9]+"
                        },
                        "parameters": [],
                        "parameterNames": [],
                        "computedMiddleware": [
                            "api"
                        ],
                        "compiled": {}
                    },
                    {
                        "headers": {
                            "Content-Type": "application\/json",
                            "Accept": "application\/json",
                            "Content-Language": "en",
                            "X-AppApiToken": "a25ydDlKdDRwT2wzYjAxV1hvc0hSUmQxYklTTE1pRHU=",
                            "X-AppType": "docs"
                        },
                        "response_calls": {
                            "methods": [
                                "*"
                            ],
                            "config": {
                                "app.env": "local",
                                "app.debug": false
                            },
                            "queryParams": [],
                            "bodyParams": [],
                            "fileParams": [],
                            "cookies": []
                        }
                    },
                    {
                        "id": "0ede357cfa17e8746504eb85c997884f",
                        "methods": [
                            "POST"
                        ],
                        "uri": "api\/auth\/password\/email",
                        "metadata": {
                            "groupName": "Authentication",
                            "groupDescription": "",
                            "title": "Forgot password",
                            "description": "",
                            "authenticated": false
                        },
                        "urlParameters": [],
                        "cleanUrlParameters": [],
                        "boundUri": "api\/auth\/password\/email",
                        "auth": null,
                        "queryParameters": [],
                        "cleanQueryParameters": [],
                        "headers": {
                            "Content-Type": "application\/json",
                            "Accept": "application\/json",
                            "Content-Language": "en",
                            "X-AppApiToken": "a25ydDlKdDRwT2wzYjAxV1hvc0hSUmQxYklTTE1pRHU=",
                            "X-AppType": "docs"
                        },
                        "bodyParameters": {
                            "login": {
                                "name": "login",
                                "type": "string",
                                "description": "The user's login (Can be email address or phone number).",
                                "required": true,
                                "value": "user@demosite.com"
                            },
                            "captcha_key": {
                                "name": "captcha_key",
                                "type": "string",
                                "description": "Key generated by the CAPTCHA endpoint calling (Required if the CAPTCHA verification is enabled from the Admin panel).",
                                "required": false,
                                "value": "accusamus"
                            }
                        },
                        "cleanBodyParameters": {
                            "login": "user@demosite.com",
                            "captcha_key": "accusamus"
                        },
                        "fileParameters": [],
                        "responses": []
                    }
                ]
            },
            {
                "file": "\/Users\/mayeul\/CODES\/PROJECTS\/jobclass\/vendor\/knuckleswtf\/scribe\/src\/Extracting\/Generator.php",
                "line": 236,
                "function": "__invoke",
                "class": "Knuckles\\Scribe\\Extracting\\Strategies\\Responses\\ResponseCalls",
                "type": "->",
                "args": [
                    {
                        "uri": "api\/auth\/password\/email",
                        "methods": [
                            "POST"
                        ],
                        "action": {
                            "middleware": [
                                "api"
                            ],
                            "uses": "App\\Http\\Controllers\\Api\\Auth\\ForgotPasswordController@sendResetLink",
                            "controller": "App\\Http\\Controllers\\Api\\Auth\\ForgotPasswordController@sendResetLink",
                            "namespace": "App\\Http\\Controllers\\Api\\Auth",
                            "prefix": "api\/auth",
                            "where": [],
                            "as": "auth.password.email"
                        },
                        "isFallback": false,
                        "controller": {
                            "locale": null,
                            "countryCode": null,
                            "messages": [],
                            "errors": [],
                            "cacheExpiration": 86400,
                            "perPage": "16",
                            "disk": {},
                            "cookieExpiration": 86400
                        },
                        "defaults": [],
                        "wheres": {
                            "userId": "[0-9]+"
                        },
                        "parameters": [],
                        "parameterNames": [],
                        "computedMiddleware": [
                            "api"
                        ],
                        "compiled": {}
                    },
                    {
                        "name": "App\\Http\\Controllers\\Api\\Auth\\ForgotPasswordController"
                    },
                    {
                        "name": "sendResetLink",
                        "class": "App\\Http\\Controllers\\Api\\Auth\\ForgotPasswordController"
                    },
                    {
                        "headers": {
                            "Content-Type": "application\/json",
                            "Accept": "application\/json",
                            "Content-Language": "en",
                            "X-AppApiToken": "a25ydDlKdDRwT2wzYjAxV1hvc0hSUmQxYklTTE1pRHU=",
                            "X-AppType": "docs"
                        },
                        "response_calls": {
                            "methods": [
                                "*"
                            ],
                            "config": {
                                "app.env": "local",
                                "app.debug": false
                            },
                            "queryParams": [],
                            "bodyParams": [],
                            "fileParams": [],
                            "cookies": []
                        }
                    },
                    {
                        "id": "0ede357cfa17e8746504eb85c997884f",
                        "methods": [
                            "POST"
                        ],
                        "uri": "api\/auth\/password\/email",
                        "metadata": {
                            "groupName": "Authentication",
                            "groupDescription": "",
                            "title": "Forgot password",
                            "description": "",
                            "authenticated": false
                        },
                        "urlParameters": [],
                        "cleanUrlParameters": [],
                        "boundUri": "api\/auth\/password\/email",
                        "auth": null,
                        "queryParameters": [],
                        "cleanQueryParameters": [],
                        "headers": {
                            "Content-Type": "application\/json",
                            "Accept": "application\/json",
                            "Content-Language": "en",
                            "X-AppApiToken": "a25ydDlKdDRwT2wzYjAxV1hvc0hSUmQxYklTTE1pRHU=",
                            "X-AppType": "docs"
                        },
                        "bodyParameters": {
                            "login": {
                                "name": "login",
                                "type": "string",
                                "description": "The user's login (Can be email address or phone number).",
                                "required": true,
                                "value": "user@demosite.com"
                            },
                            "captcha_key": {
                                "name": "captcha_key",
                                "type": "string",
                                "description": "Key generated by the CAPTCHA endpoint calling (Required if the CAPTCHA verification is enabled from the Admin panel).",
                                "required": false,
                                "value": "accusamus"
                            }
                        },
                        "cleanBodyParameters": {
                            "login": "user@demosite.com",
                            "captcha_key": "accusamus"
                        },
                        "fileParameters": [],
                        "responses": []
                    }
                ]
            },
            {
                "file": "\/Users\/mayeul\/CODES\/PROJECTS\/jobclass\/vendor\/knuckleswtf\/scribe\/src\/Extracting\/Generator.php",
                "line": 172,
                "function": "iterateThroughStrategies",
                "class": "Knuckles\\Scribe\\Extracting\\Generator",
                "type": "->",
                "args": [
                    "responses",
                    {
                        "id": "0ede357cfa17e8746504eb85c997884f",
                        "methods": [
                            "POST"
                        ],
                        "uri": "api\/auth\/password\/email",
                        "metadata": {
                            "groupName": "Authentication",
                            "groupDescription": "",
                            "title": "Forgot password",
                            "description": "",
                            "authenticated": false
                        },
                        "urlParameters": [],
                        "cleanUrlParameters": [],
                        "boundUri": "api\/auth\/password\/email",
                        "auth": null,
                        "queryParameters": [],
                        "cleanQueryParameters": [],
                        "headers": {
                            "Content-Type": "application\/json",
                            "Accept": "application\/json",
                            "Content-Language": "en",
                            "X-AppApiToken": "a25ydDlKdDRwT2wzYjAxV1hvc0hSUmQxYklTTE1pRHU=",
                            "X-AppType": "docs"
                        },
                        "bodyParameters": {
                            "login": {
                                "name": "login",
                                "type": "string",
                                "description": "The user's login (Can be email address or phone number).",
                                "required": true,
                                "value": "user@demosite.com"
                            },
                            "captcha_key": {
                                "name": "captcha_key",
                                "type": "string",
                                "description": "Key generated by the CAPTCHA endpoint calling (Required if the CAPTCHA verification is enabled from the Admin panel).",
                                "required": false,
                                "value": "accusamus"
                            }
                        },
                        "cleanBodyParameters": {
                            "login": "user@demosite.com",
                            "captcha_key": "accusamus"
                        },
                        "fileParameters": [],
                        "responses": []
                    },
                    [
                        {
                            "uri": "api\/auth\/password\/email",
                            "methods": [
                                "POST"
                            ],
                            "action": {
                                "middleware": [
                                    "api"
                                ],
                                "uses": "App\\Http\\Controllers\\Api\\Auth\\ForgotPasswordController@sendResetLink",
                                "controller": "App\\Http\\Controllers\\Api\\Auth\\ForgotPasswordController@sendResetLink",
                                "namespace": "App\\Http\\Controllers\\Api\\Auth",
                                "prefix": "api\/auth",
                                "where": [],
                                "as": "auth.password.email"
                            },
                            "isFallback": false,
                            "controller": {
                                "locale": null,
                                "countryCode": null,
                                "messages": [],
                                "errors": [],
                                "cacheExpiration": 86400,
                                "perPage": "16",
                                "disk": {},
                                "cookieExpiration": 86400
                            },
                            "defaults": [],
                            "wheres": {
                                "userId": "[0-9]+"
                            },
                            "parameters": [],
                            "parameterNames": [],
                            "computedMiddleware": [
                                "api"
                            ],
                            "compiled": {}
                        },
                        {
                            "name": "App\\Http\\Controllers\\Api\\Auth\\ForgotPasswordController"
                        },
                        {
                            "name": "sendResetLink",
                            "class": "App\\Http\\Controllers\\Api\\Auth\\ForgotPasswordController"
                        },
                        {
                            "headers": {
                                "Content-Type": "application\/json",
                                "Accept": "application\/json",
                                "Content-Language": "en",
                                "X-AppApiToken": "a25ydDlKdDRwT2wzYjAxV1hvc0hSUmQxYklTTE1pRHU=",
                                "X-AppType": "docs"
                            },
                            "response_calls": {
                                "methods": [
                                    "*"
                                ],
                                "config": {
                                    "app.env": "local",
                                    "app.debug": false
                                },
                                "queryParams": [],
                                "bodyParams": [],
                                "fileParams": [],
                                "cookies": []
                            }
                        }
                    ]
                ]
            },
            {
                "file": "\/Users\/mayeul\/CODES\/PROJECTS\/jobclass\/vendor\/knuckleswtf\/scribe\/src\/Extracting\/Generator.php",
                "line": 127,
                "function": "fetchResponses",
                "class": "Knuckles\\Scribe\\Extracting\\Generator",
                "type": "->",
                "args": [
                    {
                        "name": "App\\Http\\Controllers\\Api\\Auth\\ForgotPasswordController"
                    },
                    {
                        "name": "sendResetLink",
                        "class": "App\\Http\\Controllers\\Api\\Auth\\ForgotPasswordController"
                    },
                    {
                        "uri": "api\/auth\/password\/email",
                        "methods": [
                            "POST"
                        ],
                        "action": {
                            "middleware": [
                                "api"
                            ],
                            "uses": "App\\Http\\Controllers\\Api\\Auth\\ForgotPasswordController@sendResetLink",
                            "controller": "App\\Http\\Controllers\\Api\\Auth\\ForgotPasswordController@sendResetLink",
                            "namespace": "App\\Http\\Controllers\\Api\\Auth",
                            "prefix": "api\/auth",
                            "where": [],
                            "as": "auth.password.email"
                        },
                        "isFallback": false,
                        "controller": {
                            "locale": null,
                            "countryCode": null,
                            "messages": [],
                            "errors": [],
                            "cacheExpiration": 86400,
                            "perPage": "16",
                            "disk": {},
                            "cookieExpiration": 86400
                        },
                        "defaults": [],
                        "wheres": {
                            "userId": "[0-9]+"
                        },
                        "parameters": [],
                        "parameterNames": [],
                        "computedMiddleware": [
                            "api"
                        ],
                        "compiled": {}
                    },
                    {
                        "headers": {
                            "Content-Type": "application\/json",
                            "Accept": "application\/json",
                            "Content-Language": "en",
                            "X-AppApiToken": "a25ydDlKdDRwT2wzYjAxV1hvc0hSUmQxYklTTE1pRHU=",
                            "X-AppType": "docs"
                        },
                        "response_calls": {
                            "methods": [
                                "*"
                            ],
                            "config": {
                                "app.env": "local",
                                "app.debug": false
                            },
                            "queryParams": [],
                            "bodyParams": [],
                            "fileParams": [],
                            "cookies": []
                        }
                    },
                    {
                        "id": "0ede357cfa17e8746504eb85c997884f",
                        "methods": [
                            "POST"
                        ],
                        "uri": "api\/auth\/password\/email",
                        "metadata": {
                            "groupName": "Authentication",
                            "groupDescription": "",
                            "title": "Forgot password",
                            "description": "",
                            "authenticated": false
                        },
                        "urlParameters": [],
                        "cleanUrlParameters": [],
                        "boundUri": "api\/auth\/password\/email",
                        "auth": null,
                        "queryParameters": [],
                        "cleanQueryParameters": [],
                        "headers": {
                            "Content-Type": "application\/json",
                            "Accept": "application\/json",
                            "Content-Language": "en",
                            "X-AppApiToken": "a25ydDlKdDRwT2wzYjAxV1hvc0hSUmQxYklTTE1pRHU=",
                            "X-AppType": "docs"
                        },
                        "bodyParameters": {
                            "login": {
                                "name": "login",
                                "type": "string",
                                "description": "The user's login (Can be email address or phone number).",
                                "required": true,
                                "value": "user@demosite.com"
                            },
                            "captcha_key": {
                                "name": "captcha_key",
                                "type": "string",
                                "description": "Key generated by the CAPTCHA endpoint calling (Required if the CAPTCHA verification is enabled from the Admin panel).",
                                "required": false,
                                "value": "accusamus"
                            }
                        },
                        "cleanBodyParameters": {
                            "login": "user@demosite.com",
                            "captcha_key": "accusamus"
                        },
                        "fileParameters": []
                    }
                ]
            },
            {
                "file": "\/Users\/mayeul\/CODES\/PROJECTS\/jobclass\/vendor\/knuckleswtf\/scribe\/src\/Commands\/GenerateDocumentation.php",
                "line": 119,
                "function": "processRoute",
                "class": "Knuckles\\Scribe\\Extracting\\Generator",
                "type": "->",
                "args": [
                    {
                        "uri": "api\/auth\/password\/email",
                        "methods": [
                            "POST"
                        ],
                        "action": {
                            "middleware": [
                                "api"
                            ],
                            "uses": "App\\Http\\Controllers\\Api\\Auth\\ForgotPasswordController@sendResetLink",
                            "controller": "App\\Http\\Controllers\\Api\\Auth\\ForgotPasswordController@sendResetLink",
                            "namespace": "App\\Http\\Controllers\\Api\\Auth",
                            "prefix": "api\/auth",
                            "where": [],
                            "as": "auth.password.email"
                        },
                        "isFallback": false,
                        "controller": {
                            "locale": null,
                            "countryCode": null,
                            "messages": [],
                            "errors": [],
                            "cacheExpiration": 86400,
                            "perPage": "16",
                            "disk": {},
                            "cookieExpiration": 86400
                        },
                        "defaults": [],
                        "wheres": {
                            "userId": "[0-9]+"
                        },
                        "parameters": [],
                        "parameterNames": [],
                        "computedMiddleware": [
                            "api"
                        ],
                        "compiled": {}
                    },
                    {
                        "headers": {
                            "Content-Type": "application\/json",
                            "Accept": "application\/json",
                            "Content-Language": "en",
                            "X-AppApiToken": "a25ydDlKdDRwT2wzYjAxV1hvc0hSUmQxYklTTE1pRHU=",
                            "X-AppType": "docs"
                        },
                        "response_calls": {
                            "methods": [
                                "*"
                            ],
                            "config": {
                                "app.env": "local",
                                "app.debug": false
                            },
                            "queryParams": [],
                            "bodyParams": [],
                            "fileParams": [],
                            "cookies": []
                        }
                    }
                ]
            },
            {
                "file": "\/Users\/mayeul\/CODES\/PROJECTS\/jobclass\/vendor\/knuckleswtf\/scribe\/src\/Commands\/GenerateDocumentation.php",
                "line": 73,
                "function": "processRoutes",
                "class": "Knuckles\\Scribe\\Commands\\GenerateDocumentation",
                "type": "->",
                "args": [
                    [
                        {},
                        {},
                        {},
                        {},
                        {},
                        {},
                        {},
                        {},
                        {},
                        {},
                        {},
                        {},
                        {},
                        {},
                        {},
                        {},
                        {},
                        {},
                        {},
                        {},
                        {},
                        {},
                        {},
                        {},
                        {},
                        {},
                        {},
                        {},
                        {},
                        {},
                        {},
                        {},
                        {},
                        {},
                        {},
                        {},
                        {},
                        {},
                        {},
                        {},
                        {},
                        {},
                        {},
                        {},
                        {},
                        {},
                        {},
                        {},
                        {},
                        {},
                        {},
                        {},
                        {},
                        {},
                        {},
                        {},
                        {},
                        {},
                        {},
                        {},
                        {},
                        {},
                        {},
                        {},
                        {},
                        {},
                        {},
                        {},
                        {}
                    ]
                ]
            },
            {
                "file": "\/Users\/mayeul\/CODES\/PROJECTS\/jobclass\/vendor\/laravel\/framework\/src\/Illuminate\/Container\/BoundMethod.php",
                "line": 36,
                "function": "handle",
                "class": "Knuckles\\Scribe\\Commands\\GenerateDocumentation",
                "type": "->",
                "args": [
                    {}
                ]
            },
            {
                "file": "\/Users\/mayeul\/CODES\/PROJECTS\/jobclass\/vendor\/laravel\/framework\/src\/Illuminate\/Container\/Util.php",
                "line": 40,
                "function": "Illuminate\\Container\\{closure}",
                "class": "Illuminate\\Container\\BoundMethod",
                "type": "::",
                "args": []
            },
            {
                "file": "\/Users\/mayeul\/CODES\/PROJECTS\/jobclass\/vendor\/laravel\/framework\/src\/Illuminate\/Container\/BoundMethod.php",
                "line": 93,
                "function": "unwrapIfClosure",
                "class": "Illuminate\\Container\\Util",
                "type": "::",
                "args": [
                    {}
                ]
            },
            {
                "file": "\/Users\/mayeul\/CODES\/PROJECTS\/jobclass\/vendor\/laravel\/framework\/src\/Illuminate\/Container\/BoundMethod.php",
                "line": 37,
                "function": "callBoundMethod",
                "class": "Illuminate\\Container\\BoundMethod",
                "type": "::",
                "args": [
                    {
                        "contextual": []
                    },
                    [
                        {},
                        "handle"
                    ],
                    {}
                ]
            },
            {
                "file": "\/Users\/mayeul\/CODES\/PROJECTS\/jobclass\/vendor\/laravel\/framework\/src\/Illuminate\/Container\/Container.php",
                "line": 614,
                "function": "call",
                "class": "Illuminate\\Container\\BoundMethod",
                "type": "::",
                "args": [
                    {
                        "contextual": []
                    },
                    [
                        {},
                        "handle"
                    ],
                    [],
                    null
                ]
            },
            {
                "file": "\/Users\/mayeul\/CODES\/PROJECTS\/jobclass\/vendor\/laravel\/framework\/src\/Illuminate\/Console\/Command.php",
                "line": 136,
                "function": "call",
                "class": "Illuminate\\Container\\Container",
                "type": "->",
                "args": [
                    [
                        {},
                        "handle"
                    ]
                ]
            },
            {
                "file": "\/Users\/mayeul\/CODES\/PROJECTS\/jobclass\/vendor\/symfony\/console\/Command\/Command.php",
                "line": 288,
                "function": "execute",
                "class": "Illuminate\\Console\\Command",
                "type": "->",
                "args": [
                    {},
                    {}
                ]
            },
            {
                "file": "\/Users\/mayeul\/CODES\/PROJECTS\/jobclass\/vendor\/laravel\/framework\/src\/Illuminate\/Console\/Command.php",
                "line": 121,
                "function": "run",
                "class": "Symfony\\Component\\Console\\Command\\Command",
                "type": "->",
                "args": [
                    {},
                    {}
                ]
            },
            {
                "file": "\/Users\/mayeul\/CODES\/PROJECTS\/jobclass\/vendor\/symfony\/console\/Application.php",
                "line": 974,
                "function": "run",
                "class": "Illuminate\\Console\\Command",
                "type": "->",
                "args": [
                    {},
                    {}
                ]
            },
            {
                "file": "\/Users\/mayeul\/CODES\/PROJECTS\/jobclass\/vendor\/symfony\/console\/Application.php",
                "line": 291,
                "function": "doRunCommand",
                "class": "Symfony\\Component\\Console\\Application",
                "type": "->",
                "args": [
                    {},
                    {},
                    {}
                ]
            },
            {
                "file": "\/Users\/mayeul\/CODES\/PROJECTS\/jobclass\/vendor\/symfony\/console\/Application.php",
                "line": 167,
                "function": "doRun",
                "class": "Symfony\\Component\\Console\\Application",
                "type": "->",
                "args": [
                    {},
                    {}
                ]
            },
            {
                "file": "\/Users\/mayeul\/CODES\/PROJECTS\/jobclass\/vendor\/laravel\/framework\/src\/Illuminate\/Console\/Application.php",
                "line": 92,
                "function": "run",
                "class": "Symfony\\Component\\Console\\Application",
                "type": "->",
                "args": [
                    {},
                    {}
                ]
            },
            {
                "file": "\/Users\/mayeul\/CODES\/PROJECTS\/jobclass\/vendor\/laravel\/framework\/src\/Illuminate\/Foundation\/Console\/Kernel.php",
                "line": 129,
                "function": "run",
                "class": "Illuminate\\Console\\Application",
                "type": "->",
                "args": [
                    {},
                    {}
                ]
            },
            {
                "file": "\/Users\/mayeul\/CODES\/PROJECTS\/jobclass\/artisan",
                "line": 37,
                "function": "handle",
                "class": "Illuminate\\Foundation\\Console\\Kernel",
                "type": "->",
                "args": [
                    {},
                    {}
                ]
            }
        ]
    },
    "error_code": 1
}
```
<div id="execution-results-POSTapi-auth-password-email" hidden>
    <blockquote>Received response<span id="execution-response-status-POSTapi-auth-password-email"></span>:</blockquote>
    <pre class="json"><code id="execution-response-content-POSTapi-auth-password-email"></code></pre>
</div>
<div id="execution-error-POSTapi-auth-password-email" hidden>
    <blockquote>Request failed with error:</blockquote>
    <pre><code id="execution-error-message-POSTapi-auth-password-email"></code></pre>
</div>
<form id="form-POSTapi-auth-password-email" data-method="POST" data-path="api/auth/password/email" data-authed="0" data-hasfiles="0" data-headers='{"Content-Type":"application\/json","Accept":"application\/json","Content-Language":"en","X-AppApiToken":"a25ydDlKdDRwT2wzYjAxV1hvc0hSUmQxYklTTE1pRHU=","X-AppType":"docs"}' onsubmit="event.preventDefault(); executeTryOut('POSTapi-auth-password-email', this);">
<h3>
    Request&nbsp;&nbsp;&nbsp;
        <button type="button" style="background-color: #8fbcd4; padding: 5px 10px; border-radius: 5px; border-width: thin;" id="btn-tryout-POSTapi-auth-password-email" onclick="tryItOut('POSTapi-auth-password-email');">Try it out ⚡</button>
    <button type="button" style="background-color: #c97a7e; padding: 5px 10px; border-radius: 5px; border-width: thin;" id="btn-canceltryout-POSTapi-auth-password-email" onclick="cancelTryOut('POSTapi-auth-password-email');" hidden>Cancel</button>&nbsp;&nbsp;
    <button type="submit" style="background-color: #6ac174; padding: 5px 10px; border-radius: 5px; border-width: thin;" id="btn-executetryout-POSTapi-auth-password-email" hidden>Send Request 💥</button>
    </h3>
<p>
<small class="badge badge-black">POST</small>
 <b><code>api/auth/password/email</code></b>
</p>
<h4 class="fancy-heading-panel"><b>Body Parameters</b></h4>
<p>
<b><code>login</code></b>&nbsp;&nbsp;<small>string</small>  &nbsp;
<input type="text" name="login" data-endpoint="POSTapi-auth-password-email" data-component="body" required  hidden>
<br>
The user's login (Can be email address or phone number).
</p>
<p>
<b><code>captcha_key</code></b>&nbsp;&nbsp;<small>string</small>     <i>optional</i> &nbsp;
<input type="text" name="captcha_key" data-endpoint="POSTapi-auth-password-email" data-component="body"  hidden>
<br>
Key generated by the CAPTCHA endpoint calling (Required if the CAPTCHA verification is enabled from the Admin panel).
</p>

</form>


## Reset password token


Reset password token verification

> Example request:

```bash
curl -X POST \
    "https://jobclass.bedigit.local/api/auth/password/token" \
    -H "Content-Type: application/json" \
    -H "Accept: application/json" \
    -H "Content-Language: en" \
    -H "X-AppApiToken: a25ydDlKdDRwT2wzYjAxV1hvc0hSUmQxYklTTE1pRHU=" \
    -H "X-AppType: docs"
```

```javascript
const url = new URL(
    "https://jobclass.bedigit.local/api/auth/password/token"
);

let headers = {
    "Content-Type": "application/json",
    "Accept": "application/json",
    "Content-Language": "en",
    "X-AppApiToken": "a25ydDlKdDRwT2wzYjAxV1hvc0hSUmQxYklTTE1pRHU=",
    "X-AppType": "docs",
};


fetch(url, {
    method: "POST",
    headers,
}).then(response => response.json());
```

```php

$client = new \GuzzleHttp\Client();
$response = $client->post(
    'https://jobclass.bedigit.local/api/auth/password/token',
    [
        'headers' => [
            'Accept' => 'application/json',
            'Content-Language' => 'en',
            'X-AppApiToken' => 'a25ydDlKdDRwT2wzYjAxV1hvc0hSUmQxYklTTE1pRHU=',
            'X-AppType' => 'docs',
        ],
    ]
);
$body = $response->getBody();
print_r(json_decode((string) $body));
```


> Example response (422):

```json
{
    "success": false,
    "message": "The given data was invalid.",
    "result": null,
    "errors": {
        "code": [
            "The code field is required."
        ]
    },
    "error_code": 1
}
```
<div id="execution-results-POSTapi-auth-password-token" hidden>
    <blockquote>Received response<span id="execution-response-status-POSTapi-auth-password-token"></span>:</blockquote>
    <pre class="json"><code id="execution-response-content-POSTapi-auth-password-token"></code></pre>
</div>
<div id="execution-error-POSTapi-auth-password-token" hidden>
    <blockquote>Request failed with error:</blockquote>
    <pre><code id="execution-error-message-POSTapi-auth-password-token"></code></pre>
</div>
<form id="form-POSTapi-auth-password-token" data-method="POST" data-path="api/auth/password/token" data-authed="0" data-hasfiles="0" data-headers='{"Content-Type":"application\/json","Accept":"application\/json","Content-Language":"en","X-AppApiToken":"a25ydDlKdDRwT2wzYjAxV1hvc0hSUmQxYklTTE1pRHU=","X-AppType":"docs"}' onsubmit="event.preventDefault(); executeTryOut('POSTapi-auth-password-token', this);">
<h3>
    Request&nbsp;&nbsp;&nbsp;
        <button type="button" style="background-color: #8fbcd4; padding: 5px 10px; border-radius: 5px; border-width: thin;" id="btn-tryout-POSTapi-auth-password-token" onclick="tryItOut('POSTapi-auth-password-token');">Try it out ⚡</button>
    <button type="button" style="background-color: #c97a7e; padding: 5px 10px; border-radius: 5px; border-width: thin;" id="btn-canceltryout-POSTapi-auth-password-token" onclick="cancelTryOut('POSTapi-auth-password-token');" hidden>Cancel</button>&nbsp;&nbsp;
    <button type="submit" style="background-color: #6ac174; padding: 5px 10px; border-radius: 5px; border-width: thin;" id="btn-executetryout-POSTapi-auth-password-token" hidden>Send Request 💥</button>
    </h3>
<p>
<small class="badge badge-black">POST</small>
 <b><code>api/auth/password/token</code></b>
</p>
</form>


## Reset password




> Example request:

```bash
curl -X POST \
    "https://jobclass.bedigit.local/api/auth/password/reset" \
    -H "Content-Type: application/json" \
    -H "Accept: application/json" \
    -H "Content-Language: en" \
    -H "X-AppApiToken: a25ydDlKdDRwT2wzYjAxV1hvc0hSUmQxYklTTE1pRHU=" \
    -H "X-AppType: docs" \
    -d '{"login":"john.doe@domain.tld","password":"js!X07$z61hLA","password_confirmation":"js!X07$z61hLA","captcha_key":"quis"}'

```

```javascript
const url = new URL(
    "https://jobclass.bedigit.local/api/auth/password/reset"
);

let headers = {
    "Content-Type": "application/json",
    "Accept": "application/json",
    "Content-Language": "en",
    "X-AppApiToken": "a25ydDlKdDRwT2wzYjAxV1hvc0hSUmQxYklTTE1pRHU=",
    "X-AppType": "docs",
};

let body = {
    "login": "john.doe@domain.tld",
    "password": "js!X07$z61hLA",
    "password_confirmation": "js!X07$z61hLA",
    "captcha_key": "quis"
}

fetch(url, {
    method: "POST",
    headers,
    body: JSON.stringify(body),
}).then(response => response.json());
```

```php

$client = new \GuzzleHttp\Client();
$response = $client->post(
    'https://jobclass.bedigit.local/api/auth/password/reset',
    [
        'headers' => [
            'Accept' => 'application/json',
            'Content-Language' => 'en',
            'X-AppApiToken' => 'a25ydDlKdDRwT2wzYjAxV1hvc0hSUmQxYklTTE1pRHU=',
            'X-AppType' => 'docs',
        ],
        'json' => [
            'login' => 'john.doe@domain.tld',
            'password' => 'js!X07$z61hLA',
            'password_confirmation' => 'js!X07$z61hLA',
            'captcha_key' => 'quis',
        ],
    ]
);
$body = $response->getBody();
print_r(json_decode((string) $body));
```


> Example response (422):

```json
{
    "success": false,
    "message": "The given data was invalid.",
    "result": null,
    "errors": {
        "token": [
            "The token field is required."
        ]
    },
    "error_code": 1
}
```
<div id="execution-results-POSTapi-auth-password-reset" hidden>
    <blockquote>Received response<span id="execution-response-status-POSTapi-auth-password-reset"></span>:</blockquote>
    <pre class="json"><code id="execution-response-content-POSTapi-auth-password-reset"></code></pre>
</div>
<div id="execution-error-POSTapi-auth-password-reset" hidden>
    <blockquote>Request failed with error:</blockquote>
    <pre><code id="execution-error-message-POSTapi-auth-password-reset"></code></pre>
</div>
<form id="form-POSTapi-auth-password-reset" data-method="POST" data-path="api/auth/password/reset" data-authed="0" data-hasfiles="0" data-headers='{"Content-Type":"application\/json","Accept":"application\/json","Content-Language":"en","X-AppApiToken":"a25ydDlKdDRwT2wzYjAxV1hvc0hSUmQxYklTTE1pRHU=","X-AppType":"docs"}' onsubmit="event.preventDefault(); executeTryOut('POSTapi-auth-password-reset', this);">
<h3>
    Request&nbsp;&nbsp;&nbsp;
        <button type="button" style="background-color: #8fbcd4; padding: 5px 10px; border-radius: 5px; border-width: thin;" id="btn-tryout-POSTapi-auth-password-reset" onclick="tryItOut('POSTapi-auth-password-reset');">Try it out ⚡</button>
    <button type="button" style="background-color: #c97a7e; padding: 5px 10px; border-radius: 5px; border-width: thin;" id="btn-canceltryout-POSTapi-auth-password-reset" onclick="cancelTryOut('POSTapi-auth-password-reset');" hidden>Cancel</button>&nbsp;&nbsp;
    <button type="submit" style="background-color: #6ac174; padding: 5px 10px; border-radius: 5px; border-width: thin;" id="btn-executetryout-POSTapi-auth-password-reset" hidden>Send Request 💥</button>
    </h3>
<p>
<small class="badge badge-black">POST</small>
 <b><code>api/auth/password/reset</code></b>
</p>
<h4 class="fancy-heading-panel"><b>Body Parameters</b></h4>
<p>
<b><code>login</code></b>&nbsp;&nbsp;<small>string</small>  &nbsp;
<input type="text" name="login" data-endpoint="POSTapi-auth-password-reset" data-component="body" required  hidden>
<br>
The user's login (Can be email address or phone number).
</p>
<p>
<b><code>password</code></b>&nbsp;&nbsp;<small>string</small>  &nbsp;
<input type="password" name="password" data-endpoint="POSTapi-auth-password-reset" data-component="body" required  hidden>
<br>
The user's password.
</p>
<p>
<b><code>password_confirmation</code></b>&nbsp;&nbsp;<small>string</small>  &nbsp;
<input type="password" name="password_confirmation" data-endpoint="POSTapi-auth-password-reset" data-component="body" required  hidden>
<br>
The confirmation of the user's password.
</p>
<p>
<b><code>captcha_key</code></b>&nbsp;&nbsp;<small>string</small>     <i>optional</i> &nbsp;
<input type="text" name="captcha_key" data-endpoint="POSTapi-auth-password-reset" data-component="body"  hidden>
<br>
Key generated by the CAPTCHA endpoint calling (Required if the CAPTCHA verification is enabled from the Admin panel).
</p>

</form>



